<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class CartCheckoutController extends Controller
{
    public function showCheckoutForm()
    {
        return view('cart.checkout');
    }

    public function initializeCheckout(Request $request)
    {
        $request->validate([
            'cart_id' => 'required|string',
            'amount' => 'required|numeric|min:1',
            'currency' => 'required|string|size:3',
        ]);

        try {
            // Call the API endpoint with local server URL
            $response = Http::withHeaders([
                'Accept' => 'application/json',
                'Content-Type' => 'application/json',
            ])->post('http://127.0.0.1:8000/api/v1/checkout/initialize', [
                'cart_id' => $request->cart_id,
                'amount' => $request->amount,
                'currency' => $request->currency,
            ]);

            if ($response->successful()) {
                $data = $response->json();
                return view('cart.process', [
                    'clientSecret' => $data['data']['client_secret'],
                    'paymentIntentId' => $data['data']['payment_intent_id'],
                    'amount' => $request->amount,
                    'currency' => $request->currency
                ]);
            }

            return back()->with('error', 'Failed to initialize checkout: ' . ($response->json()['message'] ?? 'Unknown error'));
        } catch (\Exception $e) {
            return back()->with('error', 'Error: ' . $e->getMessage());
        }
    }
} 