<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Notifications\DatabaseNotification;
use Illuminate\Support\Facades\Auth;

class NotificationController extends Controller
{
    // Fetch all notifications (paginated)
    public function index(Request $request)
    {
        $user = $request->user();
        $notifications = $user->notifications()->paginate(20);
        return response()->json($notifications);
    }

    // Fetch unread notifications (paginated)
    public function unread(Request $request)
    {
        $user = $request->user();
        $notifications = $user->unreadNotifications()->paginate(20);
        return response()->json($notifications);
    }

    // Mark a notification as read
    public function markAsRead(Request $request, $id)
    {
        $user = $request->user();
        $notification = $user->notifications()->where('id', $id)->firstOrFail();
        $notification->markAsRead();
        return response()->json(['success' => true]);
    }

    // Mark a notification as unread
    public function markAsUnread(Request $request, $id)
    {
        $user = $request->user();
        $notification = $user->notifications()->where('id', $id)->firstOrFail();
        $notification->update(['read_at' => null]);
        return response()->json(['success' => true]);
    }

    // Delete a notification
    public function destroy(Request $request, $id)
    {
        $user = $request->user();
        $notification = $user->notifications()->where('id', $id)->firstOrFail();
        $notification->delete();
        return response()->json(['success' => true]);
    }
} 