<?php

namespace App\Http\Controllers;

use App\Models\ManualInvoice;
use Illuminate\Support\Facades\Cache;

class PaymentLinkController extends Controller
{
    /**
     * Public endpoint to resolve a payment token and return invoice info.
     */
    public function resolve(string $token)
    {
        $data = Cache::get('manual_invoice_token:' . $token);
        if (!$data) {
            return response()->json([
                'success' => false,
                'message' => 'Invalid or expired payment link'
            ], 404);
        }

        $invoiceId = $data['manual_invoice_id'] ?? null;
        $invoice = $invoiceId ? ManualInvoice::with('order.items')->find($invoiceId) : null;
        if (!$invoice) {
            return response()->json([
                'success' => false,
                'message' => 'Invoice not found for this link'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => [
                'invoice' => $invoice,
                'expires_at' => $data['expires_at'] ?? null,
            ]
        ]);
    }
}


