<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DeliveryAttempt extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'shipment_id',
        'attempt_date',
        'status',
        'reason',
        'notes',
        'signature_image',
        'proof_of_delivery_image',
        'delivery_person'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'attempt_date' => 'datetime',
    ];

    /**
     * Get the shipment that owns the delivery attempt.
     */
    public function shipment()
    {
        return $this->belongsTo(Shipment::class);
    }
}