<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DeliverySchedule extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'order_id',
        'shipment_id',
        'scheduled_date',
        'time_slot_start',
        'time_slot_end',
        'contact_name',
        'contact_phone',
        'status',
        'notes'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'scheduled_date' => 'date',
        'time_slot_start' => 'datetime',
        'time_slot_end' => 'datetime',
    ];

    /**
     * Get the order that owns the delivery schedule.
     */
    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    /**
     * Get the shipment for this delivery schedule.
     */
    public function shipment()
    {
        return $this->belongsTo(Shipment::class);
    }
}