<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FulfillmentOrder extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'order_id',
        'warehouse_id',
        'status',
        'priority',
        'assigned_to',
        'notes'
    ];

    /**
     * Get the order that owns the fulfillment order.
     */
    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    /**
     * Get the warehouse for this fulfillment order.
     */
    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }

    /**
     * Get the user assigned to this fulfillment order.
     */
    public function assignedTo()
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }

    /**
     * Get the items for the fulfillment order.
     */
    public function items()
    {
        return $this->hasMany(FulfillmentItem::class);
    }
}