<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VendorMembership extends Model
{
    use HasFactory;

    protected $table = 'vendor_memberships';

    protected $fillable = [
        'name',
        'normal_discount',
        'extra_discount',
    ];

    /**
     * Get all vendor profiles with this membership.
     */
    public function vendorProfiles()
    {
        return $this->hasMany(VendorProfile::class, 'membership_id');
    }
} 