<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VendorProfile extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'company_name',
        'company_logo',
        'company_description',
        'business_registration_number',
        'is_approved',
        'membership_id', // Added for membership relationship
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_approved' => 'boolean',
    ];

    /**
     * Get the user that owns the vendor profile.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get products belonging to this vendor.
     */
    public function products()
    {
        return $this->hasMany(Product::class, 'vendor_id', 'user_id');
    }

    /**
     * Get the membership type for the vendor.
     */
    public function membership()
    {
        return $this->belongsTo(VendorMembership::class, 'membership_id');
    }
}