<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Settings
    |--------------------------------------------------------------------------
    |
    | This file contains all authentication-related configuration settings
    | for the application including token expiration, refresh token settings,
    | and other authentication preferences.
    |
    */

    /*
    |--------------------------------------------------------------------------
    | Token Expiration Settings
    |--------------------------------------------------------------------------
    |
    | Configure how long authentication tokens remain valid.
    | These settings can be overridden via environment variables.
    |
    */

    'token_expiration' => [
        'access_token' => env('SANCTUM_TOKEN_EXPIRATION', 60), // minutes
        'refresh_token' => env('REFRESH_TOKEN_EXPIRATION', 1440), // 24 hours in minutes
    ],

    /*
    |--------------------------------------------------------------------------
    | Authentication Behavior
    |--------------------------------------------------------------------------
    |
    | Configure authentication behavior and security settings.
    |
    */

    'security' => [
        'revoke_previous_tokens_on_login' => env('REVOKE_PREVIOUS_TOKENS', true),
        'max_concurrent_sessions' => env('MAX_CONCURRENT_SESSIONS', 5),
        'require_password_confirmation_for_sensitive_actions' => env('REQUIRE_PASSWORD_CONFIRMATION', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | Social Login Settings
    |--------------------------------------------------------------------------
    |
    | Configure social login providers and behavior.
    |
    */

    'social_login' => [
        'enabled_providers' => ['facebook', 'google'],
        'auto_approve_social_users' => env('AUTO_APPROVE_SOCIAL_USERS', true),
        'default_role_for_social_users' => env('DEFAULT_SOCIAL_USER_ROLE', 'buyer'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Password Policy
    |--------------------------------------------------------------------------
    |
    | Configure password requirements and policies.
    |
    */

    'password_policy' => [
        'min_length' => env('PASSWORD_MIN_LENGTH', 8),
        'require_uppercase' => env('PASSWORD_REQUIRE_UPPERCASE', true),
        'require_lowercase' => env('PASSWORD_REQUIRE_LOWERCASE', true),
        'require_numbers' => env('PASSWORD_REQUIRE_NUMBERS', true),
        'require_special_chars' => env('PASSWORD_REQUIRE_SPECIAL_CHARS', false),
    ],

]; 