<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\StripePaymentController;
use App\Http\Controllers\CartCheckoutController;
use App\Http\Controllers\TestEmailController;
use App\Http\Controllers\PaymentLinkController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group.
|
*/

Route::get('/', function () {
    return view('welcome');
});

// Stripe Payment Routes
Route::get('/payment', [StripePaymentController::class, 'showPaymentForm'])->name('payment.form');
Route::post('/payment/process', [StripePaymentController::class, 'processPayment'])->name('payment.process');

// Cart Checkout Simulation Routes
Route::get('/cart-checkout', [CartCheckoutController::class, 'showCheckoutForm'])->name('cart.checkout.form');
Route::post('/cart-checkout/initialize', [CartCheckoutController::class, 'initializeCheckout'])->name('cart.checkout.initialize');

Route::get('/payment/client-secret', function () {
    return view('payment.client_secret');
})->name('payment.client_secret');

Route::get('/send-test-email', [TestEmailController::class, 'send']);

// Public resolver for manual invoice payment links
Route::get('/pay/{token}', [PaymentLinkController::class, 'resolve']);